/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.jspemul;

import com.ibm.hwmca.fw.servlet.jspemul.JSPEmulatorException;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;

class TagInfoEmul
extends TagInfo {
    Map attributeToAttrInfo;

    public TagInfoEmul(String tagName, String tagClassName, String bodycontent, String infoString, TagLibraryInfo taglib, TagExtraInfo tagExtraInfo, TagAttributeInfo[] attributeInfo) {
        super(tagName, tagClassName, bodycontent, infoString, taglib, tagExtraInfo, attributeInfo);
    }

    public synchronized AttributeInfo getAttributeInfo(String attribute) throws JSPEmulatorException {
        AttributeInfo attrInfo;
        if (this.attributeToAttrInfo == null) {
            this.createAttributeInfo();
        }
        if ((attrInfo = (AttributeInfo)this.attributeToAttrInfo.get(attribute)) == null) {
            throw new JSPEmulatorException("The attribute \"" + attribute + "\" is used on tag \"" + this.getTagName() + "\", but the custom tag class \"" + this.getTagClassName() + "\" doesn't contain a bean property called \"" + attribute + "\".");
        }
        return attrInfo;
    }

    private Class getTagClass() throws JSPEmulatorException {
        try {
            return Class.forName(this.getTagClassName());
        }
        catch (ClassNotFoundException e) {
            throw new JSPEmulatorException("Can't resolve custom tag class name \"" + this.getTagClassName() + '\"', e);
        }
    }

    private synchronized void createAttributeInfo() throws JSPEmulatorException {
        BeanInfo beanInfo;
        this.attributeToAttrInfo = new HashMap();
        try {
            beanInfo = Introspector.getBeanInfo(this.getTagClass());
        }
        catch (IntrospectionException e) {
            throw new JSPEmulatorException("Error examining bean info for class \"" + this.getTagClassName() + '\"', e);
        }
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            Method writeMethod;
            PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
            if (propertyDescriptor instanceof IndexedPropertyDescriptor || (writeMethod = propertyDescriptor.getWriteMethod()) == null) continue;
            AttributeInfo attrInfo = new AttributeInfo();
            attrInfo.setter = writeMethod;
            attrInfo.propertyType = propertyDescriptor.getPropertyType();
            attrInfo.propertyEditorClass = propertyDescriptor.getPropertyEditorClass();
            this.attributeToAttrInfo.put(propertyDescriptor.getName(), attrInfo);
        }
    }

    public static class AttributeInfo {
        Method setter;
        Class propertyType;
        Class propertyEditorClass;
    }
}

